<?php
session_start(); // Start or resume the session

// Check if school_id is set in the URL
if (isset($_GET['school_id'])) {

    $host = "localhost";
    $username = "root";
    $password = "";
    $database = "quiz";

    $connection = new mysqli($host, $username, $password, $database);

    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    // Sanitize the input (to prevent SQL injection) and store it in a variable
    $school_id = mysqli_real_escape_string($connection, $_GET['school_id']);

    // Query to fetch school_name from the database based on school_id
    $sql = "SELECT school_name FROM schools WHERE school_id = '$school_id'";

    $result = $connection->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $school_name = $row['school_name'];

        // Store school_id and school_name in session variables
        $_SESSION['school_id'] = $school_id;
        $_SESSION['school_name'] = $school_name;
    } else {
        echo "School not found.";
    }

    // Close the database connection
    $connection->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>MILLIONAIRE QUIZ COMPETITION</title>

    <!-- Bootstrap core CSS -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="css/style.css" rel="stylesheet">

    <!-- animation stylesheet -->
    <link href="css/animate.css" rel="stylesheet">

    <!-- Fontawesome stylesheet -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding-bottom: 80px;
        }

        /* Navigation Styles */
        .navbar {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            padding: 1.2rem 0;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .navbar .back-btn {
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            transition: transform 0.3s ease;
        }

        .navbar .back-btn:hover {
            transform: translateX(-5px);
        }

        .navbar h2 {
            color: white;
            font-weight: 600;
            font-size: 1.3rem;
            margin: 0;
        }

        .gradientBtn {
            background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
            color: white;
            border: none;
            padding: 0.6rem 1.5rem;
            border-radius: 25px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 10px rgba(40, 167, 69, 0.3);
        }

        .gradientBtn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(40, 167, 69, 0.4);
        }

        /* Question Grid */
        .question-grid-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin: 1.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .question-grid-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .question-grid-header h3 {
            color: #1e3c72;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .legend {
            display: flex;
            justify-content: center;
            gap: 2rem;
            flex-wrap: wrap;
            margin-bottom: 1.5rem;
        }

        .legend-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .legend-box {
            width: 25px;
            height: 25px;
            border-radius: 5px;
            border: 2px solid #ddd;
        }

        .legend-available {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .legend-answered {
            background: #2c3e50;
        }

        .legend-blocked {
            background: #FFA500;
        }

        /* Question Box Styles */
        .square {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .square:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .square::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(45deg);
            transition: all 0.5s ease;
        }

        .square:hover::before {
            left: 100%;
        }

        .answered-bg {
            background: #2c3e50 !important;
        }

        .blocked-bg {
            background: #FFA500 !important;
        }

        .square img {
            width: 40px;
            height: 40px;
            margin-bottom: 0.5rem;
            filter: brightness(0) invert(1);
        }

        .square h1 {
            color: white;
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
        }

        .cursor-pointer {
            cursor: pointer;
        }

        a {
            text-decoration: none;
        }

        a[href="#"] {
            pointer-events: none;
            opacity: 0.7;
        }

        /* Leaderboard Styles */
        .leaderboard-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin: 1.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .leaderboard-header {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            text-align: center;
        }

        .leaderboard-header h3 {
            margin: 0;
            font-weight: 700;
        }

        .table {
            margin: 0;
        }

        .table thead {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
        }

        .table thead td {
            color: white;
            font-weight: 600;
            padding: 1rem;
            border: none;
        }

        .table tbody tr {
            transition: all 0.3s ease;
        }

        .table tbody tr:hover {
            background-color: #f8f9ff;
            transform: scale(1.01);
        }

        .ranker-profile {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border: 3px solid #2a5298;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .color-blue {
            color: #2a5298;
            font-weight: 700;
        }

        .color-purple {
            color: #764ba2;
        }

        /* Score Board */
        .scoreboard-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin: 1.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .scoreboard-container h2 {
            color: #1e3c72;
            font-weight: 700;
            margin-bottom: 1.5rem;
            text-align: center;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(102, 126, 234, 0.05);
        }

        .table-striped th {
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 1rem;
            font-weight: 600;
        }

        .table-striped td {
            padding: 1rem;
            vertical-align: middle;
        }

        /* Footer */
        .custom-footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: linear-gradient(90deg, #1e3c72 0%, #2a5298 100%);
            padding: 1rem 0;
            box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1);
        }

        .custom-footer p {
            color: white;
            margin: 0;
            text-align: center;
            font-size: 0.85rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .navbar h2 {
                font-size: 1rem;
            }

            .question-grid-container,
            .leaderboard-container,
            .scoreboard-container {
                padding: 1rem;
                margin: 1rem;
            }

            .square {
                padding: 1rem;
            }

            .square h1 {
                font-size: 1.5rem;
            }

            .legend {
                gap: 1rem;
            }
        }
    </style>
</head>

<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container">
            <a href="schools.php" class="back-btn"><i class="fas fa-arrow-left"></i></a>
            <h2>
                <i class="fas fa-clipboard-question"></i> Question Menu - <?php echo isset($_SESSION['school_name']) ? $_SESSION['school_name'] : ''; ?>
            </h2>
            <button class="gradientBtn">
                <?php include("rounds-selector.php");?>
            </button>
        </div>
    </nav>

    <!-- Category Content -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="question-grid-container">
                    <div class="question-grid-header">
                        <h3><i class="fas fa-list-check"></i> Select Question</h3>
                        <div class="legend">
                            <div class="legend-item">
                                <div class="legend-box legend-available"></div>
                                <span>Available</span>
                            </div>
                            <div class="legend-item">
                                <div class="legend-box legend-answered"></div>
                                <span>Answered</span>
                            </div>
                            <div class="legend-item">
                                <div class="legend-box legend-blocked"></div>
                                <span>Blocked</span>
                            </div>
                        </div>
                    </div>

                    <?php
                        $host = "localhost";
                        $username = "root";
                        $password = "";
                        $database = "quiz";

                        // Create a database connection
                        $connection = new mysqli($host, $username, $password, $database);

                        // Check the connection
                        if ($connection->connect_error) {
                            die("Connection failed: " . $connection->connect_error);
                        }

                        // Query to select questions from the 'question' table
                        $sql = "SELECT question_id, question, status FROM question order by id asc";

                        $result = $connection->query($sql);

                        if ($result->num_rows > 0) {
                            $questions = $result->fetch_all(MYSQLI_ASSOC);
                            $numQuestions = count($questions);

                            for ($i = 0; $i < $numQuestions; $i++) {
                                if ($i % 6 === 0) {
                                    // Start a new row
                                    echo '<div class="row">';
                                }

                                $questionID = $questions[$i]["question_id"];
                                $questionText = $questions[$i]["question"];
                                $status = $questions[$i]["status"];

                                // Apply background color based on the status
                                $backgroundClass = ($status === 'answered') ? 'answered-bg' : (($status === 'blocked') ? 'blocked-bg' : '');

                                $quizLink = 'quiz.php?question_id=' . $questionID;

                                // Generate the HTML structure for each question
                                echo '<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2">';
                                echo '<a href="' . (($status === 'answered' || $status === 'blocked') ? '#' : $quizLink) . '" ' . (($status === 'blocked') ? 'blocked' : '') . '>';
                                echo '<div class="square mt-4 cursor-pointer ' . $backgroundClass . '">';
                                echo '<center>';
                                echo '<img src="images/question-mark.gif" class="img-fluid">';
                                echo '<h1>' . $questionID . '</h1>';
                                echo '</center>';
                                echo '</div>';
                                echo '</a>';
                                echo '</div>';

                                if (($i + 1) % 6 === 0 || ($i + 1) === $numQuestions) {
                                    // End the row
                                    echo '</div>';
                                }
                            }
                        } else {
                            echo "<p class='text-center'>No questions found.</p>";
                        }

                        // Close the database connection
                        $connection->close();
                    ?>
                </div>
            </div>

            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                <!-- Leaderboard -->
                <div class="leaderboard-container">
                    <div class="leaderboard-header">
                        <h3><i class="fas fa-trophy"></i> Live Leaderboard</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <td><i class="fas fa-hashtag"></i> ID</td>
                                    <td><i class="fas fa-user"></i> Rep</td>
                                    <td><i class="fas fa-school"></i> School</td>
                                    <td><i class="fas fa-clipboard-check"></i> Attempt</td>
                                    <td><i class="fas fa-star"></i> Score</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    include("connection-string.php");
                                    
                                    // $sql1 = "SELECT s.id AS id, s.school_name, s.school_id, s.status, sp.total_question AS total_question, sp.round_id,
                                    //          ts.score as total_score
                                    //          FROM school_participation sp
                                    //          INNER JOIN schools s ON sp.school_id = s.school_id
                                    //          INNER JOIN total_scores ts ON sp.school_id = ts.school_id
                                    //          WHERE sp.status = 'in progress' AND sp.round_id = $roundId AND ts.round_id = $roundId
                                    //          GROUP BY sp.school_id";

                                    $sql1 = "
                                                SELECT 
                                                    s.id AS id,
                                                    s.school_name,
                                                    s.school_id,
                                                    s.status,
                                                    sp.total_question AS total_question,
                                                    sp.round_id,
                                                    ts.score AS total_score
                                                FROM school_participation sp
                                                INNER JOIN schools s ON sp.school_id = s.school_id
                                                INNER JOIN total_scores ts ON sp.school_id = ts.school_id
                                                WHERE sp.status = 'in progress'
                                                AND sp.round_id = $roundId
                                                AND ts.round_id = $roundId
                                                GROUP BY 
                                                    s.id, s.school_name, s.school_id, s.status, sp.total_question, sp.round_id, ts.score
                                                ";

                                             
                                    $res1 = mysqli_query($connect, $sql1);
                                    if($res1)
                                    {
                                        while($row1 = mysqli_fetch_array($res1,MYSQLI_ASSOC))
                                        {
                                            $id = $row1["id"];
                                            $school_id = $row1["school_id"];
                                            $total_question = $row1["total_question"];
                                            $school_name = $row1["school_name"];
                                            $total_score = $row1["total_score"];
                                            
                                            if($school_id == 1006)
                                            {
                                                $avatar = "images/leaderboard/female.png";
                                            }else{
                                                $avatar = "images/leaderboard/teacher.png";
                                            }
        
                                            echo "<tr class=\"shadow bg-white animated wow fadeInDown delay-0-3s\">";
                                            echo "<th scope=\"row\" class=\"color-blue\">$id</th>";
                                            echo "<td><img src=\"$avatar\" class=\"rounded-circle bg-green ranker-profile\"></td>";
                                            echo "<td><h6 class=\"text-dark\">$school_name</h6></td>";
                                            echo "<td><h5 class=\"color-purple\"><b>$total_question</b></h5></td>";
                                            echo "<td><h5 class=\"color-purple\"><b>$total_score</b></h5></td>";
                                            echo "</tr>";
                                        }
                                    }
                                ?>
                            </tbody>    
                        </table>  
                    </div>  
                </div>

                <!-- Score Board -->
                <div class="scoreboard-container">
                    <?php
                        // Database connection details
                        $servername = "localhost";
                        $username = "root";
                        $password = "";
                        $database = "quiz";
                        
                        // Create a connection to the database
                        $conn = new mysqli($servername, $username, $password, $database);
                        
                        // Check the connection
                        if ($conn->connect_error) {
                            die("Connection failed: " . $conn->connect_error);
                        }
                        
                        $sql = "SELECT * FROM schools sc where status = 'active'";
                        $result = $conn->query($sql);
                        
                        if ($result->num_rows > 0) {
                            echo '<h2><i class="fas fa-chart-bar"></i> Score Board</h2>';
                            
                            while ($row = $result->fetch_assoc()) {
                                // School ID
                                $school_id = $row["school_id"];
                                $school_name = $row["school_name"];
                               
                                // Get attempted questions for the school
                                $questions_query = "SELECT question_id, point FROM scores WHERE school_id = '$school_id' and round_id = '$roundId'";
                                $questions_result = $conn->query($questions_query);
                                
                                if ($questions_result->num_rows > 0) {
                                    // Initialize array to store question IDs
                                    $question_ids = array();
                                    
                                    // Fetch each question ID and store in array
                                    while ($row = $questions_result->fetch_assoc()) {
                                        $question_ids[] = $row['question_id']." | ".$row['point'];
                                    }
                                
                                    // Format table data
                                    $table_data = "<table class='table table-striped' border='1'><tr><th>School Name</th><th>Q1|Score</th><th>Q2|Score</th><th>Q3|Score</th><th>Q4|Score</th><th>Q5|Score</th></tr>";
                                    $table_data .= "<tr class=\"shadow bg-white animated wow fadeInDown delay-0-3s\"><td>$school_name</td>";
                                    
                                    // Loop through question IDs
                                    foreach ($question_ids as $question_id) {
                                        $table_data .= "<td>$question_id</td>";
                                    }
                                
                                    $table_data .= "</tr></table>";
                                    echo $table_data;
                                } 
                            }
                        }
                        
                        // Close the database connection
                        $conn->close();
                    ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="custom-footer">
        <p><i class="fas fa-copyright"></i> NATIONAL INSTITUTE FOR LEGISLATIVE AND DEMOCRATIC STUDIES 2023</p>
    </footer>

    <!-- Bootstrap core JavaScript -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- single selectable category -->
    <script type="text/javascript">
        $('input[type="checkbox"]').on('change', function() {
            $('input[type="checkbox"]').not(this).prop('checked', false);
        });
    </script>

    <!-- right click off -->
    <script type="text/javascript">
        document.addEventListener('contextmenu', event => event.preventDefault());
    </script>
</body>

</html>