<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title>NATIONAL INSTITUTE FOR LEGISLATIVE AND DEMOCRATIC STUDIES</title>

  <!-- Bootstrap core CSS -->
  <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">

  <!-- Custom styles for this template -->
  <link href="css/style.css" rel="stylesheet">

  <!-- animation stylesheet -->
  <link href="css/animate.css" rel="stylesheet">

  <!-- Fontawesome stylesheet -->
  <link rel="stylesheet" href="font-awesome/css/font-awesome.min.css">

  <!-- Google fonts -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap">

  <style>
    /* === Professional Design Overrides === */
    :root {
      --primary: #0A2E5C; /* Deep navy blue */
      --secondary: #D4AF37; /* Gold accent */
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
      --shadow: 0 4px 12px rgba(0,0,0,0.1);
      --radius: 12px;
    }

    body {
      font-family: 'Roboto', sans-serif;
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e7f1 100%);
      color: var(--dark);
    }

    .custom-bg {
      background: linear-gradient(to bottom, #f9fbfd, #f0f4f8);
    }

    /* Header & Logo */
    nav.navbar {
      background: transparent;
      padding: 1rem 0;
    }

    /* Hero Section */
    h1 {
      font-weight: 700;
      line-height: 1.3;
      color: var(--primary);
      font-family: 'Roboto', sans-serif !important;
      letter-spacing: -0.5px;
    }

    .gradientBtn {
      background: linear-gradient(120deg, var(--primary), #1a4a8f);
      color: white;
      border: none;
      padding: 12px 24px;
      font-weight: 600;
      border-radius: var(--radius);
      transition: all 0.3s ease;
      box-shadow: var(--shadow);
    }

    .gradientBtn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 16px rgba(10, 46, 92, 0.25);
      background: linear-gradient(120deg, #1a4a8f, var(--primary));
    }

    /* Side Navigation */
    .sidenav {
      height: 100%;
      width: 0;
      position: fixed;
      z-index: 1050;
      top: 0;
      left: 0;
      background: var(--primary);
      overflow-x: hidden;
      padding-top: 60px;
      transition: 0.4s;
      font-family: 'Roboto', sans-serif;
    }

    .sidenav a {
      padding: 16px 24px;
      text-decoration: none;
      font-size: 16px;
      color: rgba(255,255,255,0.9);
      display: block;
      transition: 0.3s;
      border-left: 3px solid transparent;
    }

    .sidenav a:hover {
      color: white;
      background: rgba(255,255,255,0.1);
      border-left: 3px solid var(--secondary);
    }

    .sidenav .closebtn {
      position: absolute;
      top: 20px;
      right: 25px;
      font-size: 36px !important;
      color: white !important;
      text-decoration: none;
    }

    .user-profile {
      width: 70px;
      height: 70px;
      object-fit: cover;
      border: 2px solid var(--secondary);
    }

    /* Modals */
    .rounded-modal {
      border-radius: var(--radius) !important;
      border: none;
      overflow: hidden;
    }

    .loginSquare {
      background: var(--primary);
      display: inline-block;
      padding: 8px 24px;
      border-radius: 0 0 var(--radius) var(--radius);
      margin-bottom: -20px;
      z-index: 10;
      position: relative;
    }

    .textfield-rounded {
      border-radius: var(--radius) !important;
      border: 1px solid #e0e6ed;
      transition: border-color 0.3s;
    }

    .textfield-rounded:focus {
      border-color: var(--secondary);
      box-shadow: 0 0 0 0.2rem rgba(212, 175, 55, 0.25);
    }

    .input-icon {
      display: flex;
      align-items: center;
      justify-content: center;
      background: var(--primary);
      padding: 0 14px;
      height: 100%;
      border-radius: var(--radius) 0 0 var(--radius);
    }

    .input-group-append .input-icon {
      border-radius: 0 var(--radius) var(--radius) 0;
    }

    .social-login {
      width: 50px;
      height: 50px;
      display: flex;
      align-items: center;
      justify-content: center;
      border: none;
      transition: transform 0.3s;
    }

    .social-login:hover {
      transform: scale(1.1);
    }

    .google-icon { color: #DB4437; font-size: 20px; }
    .fb-icon { color: #4267B2; font-size: 20px; }

    .color-blue { color: var(--secondary) !important; }
    .color-purple { color: #6f42c1 !important; }
    .color-dark { color: var(--gray) !important; }

    /* Footer */
    .m-bg {
      background: white;
      box-shadow: 0 -2px 10px rgba(0,0,0,0.05);
    }

    /* Utility Fixes */
    .ml-n5 { margin-left: -3rem !important; }
    .mr-5 { margin-right: 3rem !important; }
    .zIndex-1 { z-index: 1; }
    .z-Index-2 { z-index: 2; }

    /* Responsive tweaks */
    @media (max-width: 768px) {
      h1 { font-size: 32px !important; }
      .ml-n5, .mr-5 { margin-left: 0 !important; margin-right: 0 !important; }
    }
  </style>
</head>

<body class="custom-bg mb-3">

<!-- Your existing HTML structure remains 100% unchanged below -->
<!-- Only styles are improved — logic, classes, IDs, JS untouched -->

<div id="mySidenav" class="sidenav">
  <a href="javascript:void(0)" class="closebtn " onclick="closeNav()">&times;</a>
  <a href="#" class=""><img src="images/user.png" class="user-profile shadow img-fluid rounded-circle ml-3"/></a>
  <a href="#" class="text-white text-left"><small><p>nlidsquizmaster@gmail.com</p></small></a>
  <a href="instructions.php"><i class="fa fa-th-large text-white mr-3"></i>Quiz Instructions</a>
  <a href="schools.php"><i class="fa fa-question text-white mr-3"></i>Play Quiz</a>
  <a href="leaderboard.php"><i class="fa fa-users text-white mr-3"></i>Leaderboard</a>
</div>

<nav class="navbar navbar-expand-lg">
  <div class="container">
    <span class="menu" onclick="openNav()"><img src="images/menu.png" /></span>
    <a class="zIndex-1 ml-n5 mr-5" href="#"><img src="images/logo.png" style="width: 150px; height: 150px;" class="d-none d-sm-none d-md-block ml-n5 mr-5" /></a>
  </div>
</nav>

<!-- Login Modal -->
<div class="modal fade mt-5" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog mt-5" role="document">
    <div class="modal-content rounded-modal shadow p-3" style="margin-top: 4rem;">
      <center>
        <span class="loginSquare mt-n5"><p class="text-white" id="exampleModalLabel">Login</p></span>
      </center>
      <div class="modal-header border-0 p-0">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form><center>
          <div class="form-group input-group w-75 animated wow fadeInDown delay-0-1s">
            <input type="text" class="form-control textfield-rounded shadow-sm p-3 mb-3 zIndex-1" id="recipient-name" placeholder="Email">
            <div class="input-group-append z-Index-2">
              <span class="input-icon"><i class="fa fa-envelope text-white"></i></span>
            </div>
          </div>
          <div class="form-group input-group w-75 animated wow fadeInDown delay-0-2s">
            <div class="input-group-prepend z-Index-2">
              <span class="input-icon"><i class="fa fa-key text-white"></i></span>
            </div>
            <input type="password" class="form-control textfield-rounded shadow-sm p-3 mb-4 zIndex-1" id="recipient-pass" placeholder="Password">
          </div></center>
          <center><button type="button" class="gradientBtn w-75 animated wow fadeInDown delay-0-3s">Login</button><center>
            <p class="text-center color-blue mt-3 animated wow fadeInDown delay-0-3s">OR</p>
          </form>
        </div>
        <div class="modal-footer border-0 mt-n4">
          <center>
            <button type="button" class="btn-lg social-login rounded-circle shadow mr-4 bg-white animated wow zoomIn delay-0-5s"><i class="fa fa-google google-icon"></i></button>
            <button type="button" class="social-login rounded-circle shadow bg-white animated wow zoomIn delay-0-6s"><i class="fa fa-facebook fb-icon"></i></button>
            <p class="text-center color-dark mt-3 animated wow fadeInUp delay-0-3s">Don't have an account? <a href="#" data-dismiss="modal" class="color-blue" data-toggle="modal" data-target="#signUpModal" data-whatever="">Sign UP</a> </p>
          </center>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- SignUp Modal -->
<div class="modal fade mt-5" id="signUpModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg mt-5" role="document">
    <div class="modal-content rounded-modal shadow p-3" style="margin-top: 4rem;">
      <center>
        <span class="loginSquare mt-n5"><p class="text-white" id="exampleModalLabel">SignUp</p></span>
      </center>
      <div class="modal-header border-0 p-0">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form><center>
          <div class="row">
              <div class="col-lg-6 form-group input-group w-75 animated wow fadeInDown delay-0-1s">
                <div class="input-group-prepend z-Index-2">
                  <span class="input-icon"><i class="fa fa-user-o text-white"></i></span>
                </div>
                <input type="text" class="form-control textfield-rounded shadow-sm p-3 mb-4 zIndex-1" id="recipient-user" placeholder="Username">
              </div>
              <div class="col-lg-6 form-group input-group w-75 animated wow fadeInDown delay-0-2s">
                <div class="input-group-prepend z-Index-2">
                  <span class="input-icon"><i class="fa fa-envelope text-white"></i></span>
                </div>
                <input type="text" class="form-control textfield-rounded shadow-sm p-3 mb-4 zIndex-1" id="recipient-email" placeholder="Email">
              </div>
              <div class="col-lg-6 form-group input-group w-75 animated wow fadeInDown delay-0-3s">
                <div class="input-group-prepend z-Index-2">
                  <span class="input-icon"><i class="fa fa-key text-white"></i></span>
                </div>
                <input type="password" class="form-control textfield-rounded shadow-sm p-3 mb-4 zIndex-1" id="recipient-password" placeholder="Password">
              </div>
              <div class="col-lg-6 form-group input-group w-75 animated wow fadeInDown delay-0-4s">
                <div class="input-group-prepend z-Index-2">
                  <span class="input-icon"><i class="fa fa-key text-white"></i></span>
                </div>
                <input type="text" class="form-control textfield-rounded shadow-sm p-3 mb-4 zIndex-1" id="recipient-password" placeholder="Confirm Password">
              </div>
          </div></center>
          <center><button type="button" class="gradientBtn w-75 animated wow fadeInUp delay-0-5s">Sign UP</button><center>
            <p class="text-center color-blue mt-3 animated wow fadeInUp delay-0-5s pb-5">OR</p>
          </form>
          <div class="modal-footer border-0 mt-n5">
          <center>
            <button type="button" class="btn-lg social-login rounded-circle shadow mr-4 bg-white animated wow zoomIn delay-0-5s"><i class="fa fa-google google-icon"></i></button>
            <button type="button" class="social-login rounded-circle shadow bg-white animated wow zoomIn delay-0-6s"><i class="fa fa-facebook fb-icon"></i></button>
            <p class="text-center color-dark mt-3 animated wow fadeInUp delay-0-6s">Already have an account? <a href="#" data-dismiss="modal" class="color-purple" data-toggle="modal" data-target="#loginModal" data-whatever="">Login</a> </p>
          </center>
        </div>
        </div>
      </div>
    </div>
  </div>
</div> 

<!-- Page Content -->
<div class="container-fluid mt-5 mb-5">
  <div class="row">
    <div class="col-lg-1"></div>
    <div class="col-lg-5">
      <h1 class="color-black mt-5 animated wow fadeInDown delay-0-1s" style="font-size: 48px; font-family: 'Roboto', sans-serif;">
        <strong>WELCOME TO THE NATIONAL INSTITUTE FOR LEGISLATIVE AND DEMOCRATIC STUDIES NATIONAL QUIZ COMPETITION – 2024</strong>
      </h1>
      <a href="schools.php"><button class="gradientBtn animated wow fadeInUp delay-0-3s">Play Quiz</button></a>
    </div>
    <div class="col-lg-1"></div>
    <div class="col-lg-5"></div>
  </div>
  <div class="float-left ml-5">
   <img src="images/bottom-img.png" class="img-fluid animated wow swing slower infinite" />
 </div>
</div>

<footer class="fixed-bottom mt-5 m-bg">
  <p class="color-black ml-5" style="font-size: 12px; font-family: 'Roboto', sans-serif;"><small><strong>Copyright &copy; Powered by IBTIMI TECHNOLOGIES</strong></small></p>
</footer>

<!-- Scripts unchanged -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<script>
  function openNav() {
    document.getElementById("mySidenav").style.cssText = "width:270px; border-right: 10px solid #fff; box-shadow: 1px 8px 8px 8px rgba(73,21,155,0.3); -webkit-box-shadow: 1px 8px 8px 8px rgba(73,21,155,0.3);  -moz-box-shadow: 1px 8px 8px 8px rgba(73,21,155,0.3);";
    var element = document.getElementById("mySidenav");
    element.classList.add("animated wow bounceInLeft slow");
  }

  function closeNav() {
    document.getElementById("mySidenav").style.cssText = "width:0; border:none; box-shadow: none;";
  }
</script>

<script type="text/javascript">
  $('#loginModal').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget)
    var recipient = button.data('whatever')
    var modal = $(this)
    modal.find('.modal-title').text('New message to ' + recipient)
    modal.find('.modal-body input').val(recipient)
  })
</script>

<script type="text/javascript">
  $('#signUpModal').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget)
    var recipient = button.data('whatever')
    var modal = $(this)
    modal.find('.modal-title').text('New message to ' + recipient)
    modal.find('.modal-body input').val(recipient)
  })
</script>

<script type="text/javascript">
    document.addEventListener('contextmenu', event => event.preventDefault());
</script>

</body>
</html>